function loadReminderOptions() {
		var reminderEvent = window.arguments[0].reminder;
		var editing = window.arguments[0].editing;
		var copying = window.arguments[0].copying;
		if ( editing && !copying ) {
			document.title = 	reminderFoxBundle.getString("rf.options.reminder.edit.title");
		}
		else {
			document.title = 	reminderFoxBundle.getString("rf.options.reminder.add.title");
		}
		
		loadReminders( reminderEvent, editing);
		
}
 
 
function loadReminders(reminderEvent, editing ) {
	loadEvent( reminderEvent, editing );
							
	var remindUntilComplete = document.getElementById("remindUntilComplete");	
	var remindUntilCompleteDefault = false;
	if ( !editing ) {
		try {
			remindUntilCompleteDefault = reminderFox_prefs.getBoolPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_DEFAULT_REMIND_UNTIL_COMPLETED);
		} catch(e) {
		}	
		remindUntilComplete.setAttribute( "checked", remindUntilCompleteDefault );
	}		
	else {	
		if ( reminderEvent.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED  ||
			reminderEvent.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED ) {
				remindUntilComplete.setAttribute( "checked", true );
		}
		else {
				remindUntilComplete.setAttribute( "checked", false );
		}
	}	
		
	var readonly = window.arguments[0].readonly;		
	if ( readonly ) {
		markFieldsReadonly();
	}
	
//gW iCal  	An invitation/schedule with not beeing the ORGANIZER
//		the 'date/time', 'location, 'summary' items are disabled     			
	rmFx_inviteStatus(reminderEvent);			
}


function reminderFox_saveOptions() { 
		var reminderEvent = window.arguments[0].reminder;
		var success = reminderFox_saveReminderOptions( reminderEvent );
		
		if ( success ) {
			window.arguments[0].addReminder = true;
			window.close();
		}
}


function reminderFox_saveReminderOptions(reminderEvent) {		
	var success = saveEvent( reminderEvent );
	if ( !success ) {
		return false;
	}
	
	var remindUntilComplete = document.getElementById("remindUntilComplete");	
	var remindUntilCompleteVal =  remindUntilComplete.getAttribute("checked" );
	if ( remindUntilCompleteVal == true || remindUntilCompleteVal == "true" ) { 
		if ( reminderEvent.remindUntilCompleted  != REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED ) {
			reminderEvent.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED;
		}
	}
	else {
		reminderEvent.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_NONE;
	}	
	return true;
}
